<?
ini_set('post_max_size','100M');
ini_set('upload_max_filesize','100M');
ini_set('max_execution_time','3000');
ini_set('max_input_time','3000');
// Ultima Edici�n: 	12.12.2007
// Usuario:			Matias

class clsFormulario {

	var $_dato_id = "new";
	var $_path_imagenes = "imagenes/formularios";
	var $_path_scripts = "scripts";
	var $_datos_campos = "";
	var $_datos_validacion = "";
	var $_indice_campos = -1;
	var $_url_grabacion = "grabacion_datos.php";
	var $_url_vuelta = "";
	var $_nombretabla = "";
	var $_seteos = "";
	var $_objidioma = "";
	var $_validalocal = false;
	var $_parametros_get = "";
	
	// microsistemas
	var $_existe_upload_imagenes = false;
	var $_existe_upload_archivos = false;
	
	function clsFormulario($paramsget) {
		$this->_parametros_get = $paramsget;
		$this->PoneImplementacionesDeEstilos();
		$this->PoneFuncionesJavascript();
	}
	
	function Idioma($obj) {
		$this->_objidioma = $obj;
    }
	
	function NombreTabla($nombre) {
		$this->_nombretabla = $nombre;
	}
	
	function DatoID($valor) {
		$this->_dato_id = $valor;
	}
	
	function AgregaDato($nombre, $valor="") {
		$this->_datos_validacion[$nombre] = -1;
		$this->_indice_campos++;
		$this->_datos_campos[$this->_indice_campos] = "";
		$this->_datos_campos[$this->_indice_campos]["nombre"] 	= $nombre;
		$this->_datos_campos[$this->_indice_campos]["tipo"] 	= "dato";
		$this->_datos_campos[$this->_indice_campos]["valor"]	= $valor;
	}
	
	function AgregaEtiqueta($nombre, $valor) {
		$this->_datos_validacion[$nombre] = -1;
		$this->_indice_campos++;
		$this->_datos_campos[$this->_indice_campos] = "";
		$this->_datos_campos[$this->_indice_campos]["nombre"] 	= $nombre;
		$this->_datos_campos[$this->_indice_campos]["titulo"] 	= $this->_objidioma->Traducir($nombre);
		$this->_datos_campos[$this->_indice_campos]["tipo"]		= "etiqueta";
		$this->_datos_campos[$this->_indice_campos]["valor"]	= $valor;
	}
	
	function AgregaTexto($nombre, $valor, $ancho=null, $maximo=-1) {
		$this->_datos_validacion[$nombre] = -1;
		$this->_indice_campos++;
		$this->_datos_campos[$this->_indice_campos] = "";
		$this->_datos_campos[$this->_indice_campos]["nombre"] 	= $nombre;
		$this->_datos_campos[$this->_indice_campos]["titulo"] 	= $this->_objidioma->Traducir($nombre);
		$this->_datos_campos[$this->_indice_campos]["tipo"] 	= "texto";
		$this->_datos_campos[$this->_indice_campos]["valor"]	= $valor;
		$this->_datos_campos[$this->_indice_campos]["ancho"]	= $ancho;
		$this->_datos_campos[$this->_indice_campos]["maximo"]	= $maximo != -1 ? $maximo : $ancho;
		$this->_datos_campos[$this->_indice_campos]["validacion"]	= -1;
	}

	function AgregaFecha($nombre, $valor) {
		$this->_datos_validacion[$nombre] = "";
		$this->_indice_campos++;
		$this->_datos_campos[$this->_indice_campos] = "";
		$this->_datos_campos[$this->_indice_campos]["nombre"] 	= $nombre;
		$this->_datos_campos[$this->_indice_campos]["titulo"] 	= $this->_objidioma->Traducir($nombre);
		$this->_datos_campos[$this->_indice_campos]["tipo"] 	= "fecha";
		$this->_datos_campos[$this->_indice_campos]["valor"]	= $valor;
		$this->_datos_campos[$this->_indice_campos]["validacion"]	= "fv";
	}
	
	function AgregaArea($nombre, $valor="", $ancho=50, $renglones=10) {
		$this->_datos_validacion[$nombre] = -1;
		$this->_indice_campos++;
		$this->_datos_campos[$this->_indice_campos] = "";
		$this->_datos_campos[$this->_indice_campos]["nombre"] 	= $nombre;
		$this->_datos_campos[$this->_indice_campos]["titulo"] 	= $this->_objidioma->Traducir($nombre);
		$this->_datos_campos[$this->_indice_campos]["tipo"] 		= "area";
		$this->_datos_campos[$this->_indice_campos]["valor"]		= $valor;
		$this->_datos_campos[$this->_indice_campos]["ancho"]		= $ancho;
		$this->_datos_campos[$this->_indice_campos]["renglones"]	= $renglones;
		$this->_datos_campos[$this->_indice_campos]["validacion"]	= -1;
	}
	
	function AgregaHTML($nombre, $valor="") {
		$this->_datos_validacion[$nombre] = -1;
		$this->_indice_campos++;
		$this->_datos_campos[$this->_indice_campos] = "";
		$this->_datos_campos[$this->_indice_campos]["nombre"] 	= $nombre;
		$this->_datos_campos[$this->_indice_campos]["titulo"] 	= $this->_objidioma->Traducir($nombre);
		$this->_datos_campos[$this->_indice_campos]["tipo"] 		= "etiqueta";
		$this->_datos_campos[$this->_indice_campos]["valor"]		= $valor;
		$this->_datos_campos[$this->_indice_campos]["validacion"]	= -1;
	}
	
	function AgregaCombo($nombre, $valor="", $matrix="", $opcionseleccione=true, $opcionnuevo=false) {
		$this->_datos_validacion[$nombre] = -1;
		$this->_indice_campos++;
		$this->_datos_campos[$this->_indice_campos] = "";
		$this->_datos_campos[$this->_indice_campos]["nombre"] 	= $nombre;
		$this->_datos_campos[$this->_indice_campos]["titulo"] 	= $this->_objidioma->Traducir($nombre);
		$this->_datos_campos[$this->_indice_campos]["tipo"] 		= "combo";
		$this->_datos_campos[$this->_indice_campos]["valor"]		= $valor;
		$this->_datos_campos[$this->_indice_campos]["matrix"]	= $matrix;
		$this->_datos_campos[$this->_indice_campos]["opcionseleccione"]	= $opcionseleccione;
		$this->_datos_campos[$this->_indice_campos]["opcionnuevo"]	= $opcionnuevo;		
		$this->_datos_campos[$this->_indice_campos]["validacion"]	= -1;
	}
	
	function AgregaEstado($nombre, $valor="") {
		$this->_datos_validacion[$nombre] = -1;
		$this->_indice_campos++;
		$this->_datos_campos[$this->_indice_campos] = "";
		$this->_datos_campos[$this->_indice_campos]["nombre"] 	= $nombre;
		$this->_datos_campos[$this->_indice_campos]["titulo"] 	= $this->_objidioma->Traducir($nombre);
		$this->_datos_campos[$this->_indice_campos]["tipo"] 	= "estado";
		$this->_datos_campos[$this->_indice_campos]["valor"]	= $valor;
	}
	
	function AgregarUploadImagenes($nombre,$matrix,$matrixnombres,$path, $cantidad=1, $tamanio_thumbs=-1,$tam_maximo=400) {
		$this->ObtenerSeteos();
	
		$this->_datos_validacion[$nombre] = -1;
		$this->_indice_campos++;
		$this->_datos_campos[$this->_indice_campos] = "";
		$this->_datos_campos[$this->_indice_campos]["nombre"] 	= $nombre;
		$this->_datos_campos[$this->_indice_campos]["titulo"] 	= $this->_objidioma->Traducir($nombre);
		$this->_datos_campos[$this->_indice_campos]["tipo"] 	= "uploadimagenes";		
		$this->_datos_campos[$this->_indice_campos]["matrix"]	= $matrix;
		$this->_datos_campos[$this->_indice_campos]["matrixnombres"]	= $matrixnombres;
		$this->_datos_campos[$this->_indice_campos]["path"]		= $path;
		$this->_datos_campos[$this->_indice_campos]["cantidad"] = $cantidad;
		$this->_datos_campos[$this->_indice_campos]["tamanio_thumbs"] = $tamanio_thumbs != -1 ? $tamanio_thumbs : $this->_seteos["imagenes"]["medida_thumbs"];
		$this->_datos_campos[$this->_indice_campos]["tamanio_admin_thumbs"] = $this->_seteos["imagenes"]["medida_thumbs_admin"];
		$this->_datos_campos[$this->_indice_campos]["tam_maximo"] = $tam_maximo;
	}
	
	function AgregarUploadArchivos($nombre,$matrix,$matrixnombres,$path,$cantidad=1,$tam_maximo=600) {
		$this->_datos_validacion[$nombre] = -1;
		$this->_indice_campos++;
		$this->_datos_campos[$this->_indice_campos] = "";
		$this->_datos_campos[$this->_indice_campos]["nombre"] 	= $nombre;
		$this->_datos_campos[$this->_indice_campos]["titulo"] 	= $this->_objidioma->Traducir($nombre);
		$this->_datos_campos[$this->_indice_campos]["tipo"] 	= "uploadarchivos";		
		$this->_datos_campos[$this->_indice_campos]["matrix"]	= $matrix;
		$this->_datos_campos[$this->_indice_campos]["matrixnombres"]	= $matrixnombres;
		$this->_datos_campos[$this->_indice_campos]["path"]		= $path;
		$this->_datos_campos[$this->_indice_campos]["cantidad"] = $cantidad;
		$this->_datos_campos[$this->_indice_campos]["tam_maximo"] = $tam_maximo;
	}
		
	function UrlVuelta($url) {
		$params = str_replace("id=".$this->_dato_id."&","",$this->_parametros_get);		
		$params = str_replace("id=".$this->_dato_id,"",$params);
		$this->_url_vuelta = $url.($params == "" ? "" : "?".$params);
	}
	
	
	function ValidaLocal($estado) {
		$this->_validalocal = $estado;
	}
	
		function UrlGrabacion($url) {
		$this->_url_grabacion = $url;
	}
	
	function UrlGrabacionOK($url) {
		$this->_url_grabacion_ok = $url;
	}

	function SeteaPropiedad($prop,$valor) {
		$this->_datos_campos[$this->_indice_campos][$prop] = $valor;
	}

	function Mostrar() {
		if ($this->_indice_campos == -1) {
			return;
		}
		echo "<form name=\"frmDatos\" id=\"frmDatos\" action=\"".$this->ArmaURL()."\" method=\"POST\" class='formulario'>";
		$this->PoneVariablesInvisibles();
		echo "<table width='95%' border='1' align='center' cellpadding='4' cellspacing='0' class='Tablas'>";
		echo $this->PoneRenglonAccion();
		for ($datos=0; $datos<count($this->_datos_campos); $datos++) {
			echo $this->PoneControl($datos);
		}
		$this->PoneBotonera();
		echo "</tbody></table>";
		echo "</form>";
		$this->PoneLlamadasJavascriptAbajo();
	}
	
	function PoneRenglonAccion() {
		echo "<tr>";
		echo "<td class='TextoFormulario'><div align='center'>".($this->_objidioma->Traducir("accion"))."</div></td>";
		echo "<td class='DatosFormulario'>";
		echo $this->_dato_id == "new" ? $this->_objidioma->Traducir("nuevoregistro","formularios") : $this->_objidioma->Traducir("edicionregistro","formularios");
		echo "</td>";
		echo "</tr>";
	}
	
	function PoneControl($indice) {
		$datos = $this->_datos_campos[$indice];
		if ($datos["tipo"] == "dato") {
			$this->ControlDato($datos["nombre"],$datos["valor"]);
			return;
		}
		echo "<tr>";
		echo "<td class='TextoFormulario'><div align='center'>".$datos["titulo"]." ".$this->PoneAsteriscoValidador($indice)."</div></td>";
		echo "<td>";
		switch ($datos["tipo"]) {
			case "etiqueta":
				$this->ControlEtiqueta($datos["nombre"],$datos["valor"]);
				break;
			case "texto":
				$this->ControlTexto($datos["nombre"],$datos["valor"], $datos["ancho"], $datos["maximo"]);
				break;
			case "fecha":
				$this->ControlFecha($datos["nombre"],$datos["valor"]);
				break;
			case "area":
				$this->ControlArea($datos["nombre"],$datos["valor"],$datos["ancho"],$datos["renglones"]);
				break;
			case "estado":
				$this->ControlEstado($datos["nombre"],$datos["valor"]);
				break;
			case "combo":
				$this->ControlCombo($datos["nombre"],$datos["valor"],$datos["matrix"],$datos["opcionseleccione"],$datos["opcionnuevo"]);
				break;
			case "uploadimagenes":				
				$this->ControlUploadImagenes($datos["path"], $datos["matrix"], $datos["matrixnombres"], $datos["cantidad"],$datos["tamanio_thumbs"],$datos["tamanio_admin_thumbs"], $datos["tam_maximo"]);
				break;				
			case "uploadarchivos":
				$this->ControlUploadArchivos($datos["path"], $datos["matrix"], $datos["matrixnombres"], $datos["cantidad"], $datos["tam_maximo"]);
		}
		echo "</td>";
		echo "</tr>";
	}
	
	function ControlFecha($nombre, $valor) {
		echo "<input name='".$nombre."' id='".$nombre."' class='DatosFormulario' type='text' size='10' maxlength='10' value='".cambiaf_a_normal($valor)."'>
		<a href='javascript:void(0)' onClick=\"javascript:displayCalendar(document.getElementById('".$nombre."'),'dd-mm-yyyy',this)\"><img src='imagenes/formularios/calendario.png' title='Calendario' width='16' height='16' border='0'></a>
		<input name='frm_".$nombre."_obs' id='frm_".$nombre."_obs' type='hidden' value='fecha'> Ej. dd-mm-aaaa";
	}
	
	function ControlDato($nombre, $valor) {
		echo "<input name='".$nombre."' type='hidden' value='".$valor."' id='".$nombre."'>";
	}
	
	function ControlEtiqueta($nombre, $valor) {
		echo "<span class='DatosFormulario'>".$valor."</span>";
	}
	
	function ControlTexto($nombre, $valor, $ancho, $maximo) {
		echo "<input name='".$nombre."' type='text' class='DatosFormulario' id='".$nombre."' value='".$valor."' ".($ancho != null ? ("size='".$ancho."'"):"")." ".($ancho != null ? ("maxlength='".$maximo."'"):"")." >";
	}
	
	function ControlArea($nombre, $valor, $ancho, $renglones) {
		echo "<textarea name='".$nombre."' type='textarea' class='DatosFormulario' id='".$nombre."' cols='".$ancho."' rows='".$renglones."'>".$valor."</textarea>";
	}
	
	function ControlEstado($nombre, $valor) {
		echo "<input name='".$nombre."' type='radio' value='1' ".($valor==1 ? "checked" : "")."><span class='DatosFormulario'>Si</span>";
		echo "<input name='".$nombre."' type='radio' value='0' ".($valor==0 ? "checked" : "")."><span class='DatosFormulario'>No</span>";
	}
	
	function ControlCombo($nombre, $valor, $matrix, $opcionseleccione, $opcionnuevo) {
		echo "<select name='".$nombre."' class='DatosFormulario' id='".$nombre."' onChange=\"javascript:if(this.value==-2) { alert('na') }\">";
		$arropciones = explode("|#|",$matrix);
		if ($opcionseleccione) {
			echo "<option value='-1' selected>".($this->_objidioma->Traducir("seleccioneunaopcion","formularios"))."</option>";
		}
		for ($i=0; $i<count($arropciones); $i++) {
			$datolinea = explode("|;|",$arropciones[$i]);
			$sel = $datolinea[0] == $valor || (!$opcionseleccione && $i==0) ? " selected" : "";
			echo "<option value='".$datolinea[0]."' class='".$datolinea[2]."' ".$sel.">".$datolinea[1]."</option>";
		}
		if ($opcionnuevo) {
			echo "<option value='-2'>Nuevo Elemento</option>";
		}
		echo "</select>";
	}
	
	function ControlUploadImagenes($pathimagenes, $matrix, $matrixnombres, $cantidad, $tamaniothumbs, $tamanioadminthumbs, $tam_maximo) {
		$this->_existe_upload_imagenes = true;
		$arrimagenes = $matrix != "" ? explode("|#|",$matrix) : "";
		$arrnombres = $matrixnombres != "" ? explode("|#|",$matrixnombres) : "";
		
		$file_description = "Imagenes (*.jpg, *.jpeg)";
		$file_extension = "*.jpg; *.jpeg";
		
		echo "
			  <input name='frm_tamanio_thumbs' type='hidden' id='frm_tamanio_thumbs' value='".$tamaniothumbs."'>
			  <input name='frm_tamanio_admin_thumbs' type='hidden' id='frm_tamanio_admin_thumbs' value='".$tamanioadminthumbs."'>
			  <input name='frm_cant_imagenes_maxima' type='hidden' id='frm_cant_imagenes_maxima' value='".$cantidad."'>
			  <input name='frm_path_imagenes' type='hidden' id='frm_path_imagenes' value='".$pathimagenes."'>
			  <input name='frm_lista_imagenes' type='hidden' id='frm_lista_imagenes'>
			  <input name='frm_lista_imagenes_nombres' type='hidden' id='frm_lista_imagenes_nombres'>			  
			  <input name='frm_lista_imagenes_eliminar' type='hidden' id='frm_lista_imagenes_eliminar'>
			  <input name='frm_file_imagenes_tam_maximo' type='hidden' id='frm_file_imagenes_tam_maximo' value='".$tam_maximo."'>
			  <select name='frm_lista_imagenes_datos' id='frm_lista_imagenes_datos' style='visibility:hidden'>";
			  if ($arrimagenes != "") {
				  for ($i=0; $i<count($arrimagenes); $i++) { $tamanio_archivo = round(filesize($pathimagenes."/".$arrimagenes[$i]) / 1024);
					  echo "<option value='".$arrimagenes[$i]."|actual|".$tamanio_archivo."'>".$arrnombres[$i]."</option>";
				  }			  
			  }
		echo "</select>
			  <input name='frm_funcion_imagenes' type='hidden' id='frm_funcion_imagenes' value='AgregaImagen'>
			  <input name='frm_file_imagenes_descripcion' type='hidden' id='frm_file_imagenes_descripcion' value='".$file_description."'>
			  <input name='frm_file_imagenes_extension' type='hidden' id='frm_file_imagenes_extension' value='".$file_extension."'>
			  ";		
		echo "<div id='frm_lista_visual_imagenes'>---</div>
			  <div id='frm_formularioflash_imagenes'>Upload de Archivos</div><br />
";
	}
	
	function ControlUploadArchivos($path, $matrix, $matrixnombres, $cantidad, $tam_maximo) {
		$this->_existe_upload_archivos = true;
		$arrarchivos = $matrix != "" ? explode("|#|",$matrix) : "";
		$arrnombres = $matrixnombres != "" ? explode("|#|",$matrixnombres) : "";
		
		$file_description = "Tots els Arxius (*.*)";
		$file_extension = "*.*";
		
		echo "
			  <input name='frm_cant_archivos_maxima' type='hidden' id='frm_cant_archivos_maxima' value='".$cantidad."'>
			  <input name='frm_path_archivos' type='hidden' id='frm_path_archivos' value='".$path."'>
			  <input name='frm_lista_archivos' type='hidden' id='frm_lista_archivos'>
			  <input name='frm_lista_archivos_nombres' type='hidden' id='frm_lista_archivos_nombres'>			  
			  <input name='frm_lista_archivos_eliminar' type='hidden' id='frm_lista_archivos_eliminar'>
			  <input name='frm_file_archivos_tam_maximo' type='hidden' id='frm_file_archivos_tam_maximo' value='".$tam_maximo."'>
			  <select name='frm_lista_archivos_datos' id='frm_lista_archivos_datos' style='visibility:hidden'>";
			  if ($arrarchivos != "") {
				  for ($i=0; $i<count($arrarchivos); $i++) {
				  		$tamanio_archivo = round(filesize($path.$arrarchivos[$i]) / 1024);
					    echo "<option value='".$arrarchivos[$i]."|actual|".$tamanio_archivo."'>".$arrnombres[$i]."</option>";
				  }			  
			  }
		echo "</select>
			  <input name='frm_funcion_archivos' type='hidden' id='frm_funcion_archivos' value='AgregaArchivo'>
			  <input name='frm_file_archivos_descripcion' type='hidden' id='frm_file_archivos_descripcion' value='".$file_description."'>
			  <input name='frm_file_archivos_extension' type='hidden' id='frm_file_archivos_extension' value='".$file_extension."'>
			  ";
		echo "<div id='frm_lista_visual_archivos'>---</div>
			  <div id='frm_formularioflash_archivos'>Upload de Archivos</div><br />
";
	}
	
	function PoneBotonera() {
	if($this->_validalocal){
		$tipoboton="type='button' onClick='validarlocal()'";
	}else{
		$tipoboton="type='submit'";
	}
		echo "<tr><td colspan='2' align='center' class='TextoFormulario'>
			  <input class='botonAceptar' name='frm_btnGrabar' ".$tipoboton." value='".($this->_objidioma->Traducir("guardar","botones"))."'>
			  <input class='botonCancelar' name='frm_btnCancelar' type='button' value='".($this->_objidioma->Traducir("cancelar","botones"))."' onClick=\"javascript:location.href='".$this->_url_vuelta."'\">			  
			  </td></tr>";
	}
	
	function ArmaURL() {
		
		$matrix = "";
		for ($k=0; $k<=$this->_indice_campos; $k++) {
			$validar = isset($this->_datos_campos[$k]["validacion"]) ? $this->_datos_campos[$k]["validacion"] : -1;
			if ($validar != -1) {
				$matrix .= ($matrix != "" ? "|" : "");
				$matrix .= $this->_datos_campos[$k]["nombre"].";";
				$matrix .= $this->_datos_campos[$k]["titulo"].";";
				$matrix .= $this->_datos_campos[$k]["validacion"];
			}
		}
		$matrix = str_replace("'","\'",$matrix);
	
		$url = "javascript:ValidaFormulario('".$matrix."','".$this->_url_grabacion."')";
		return $url;
	}
	
	function PoneVariablesInvisibles() {
		echo "<input name='id' type='hidden' value='".$this->_dato_id."'>";
		echo "<input name='frm_tabla' type='hidden' value='".$this->_nombretabla."'>";
		echo "<input name='frm_url_grabacion' type='hidden' value='".$this->_url_grabacion."'>";
		echo "<input name='frm_url_grabacion_ok' type='hidden' value='".$this->_url_vuelta."'>";
	}
	
	function PoneFuncionesJavascript() {
		echo "<script language='javascript' src='".$this->_path_scripts."/formularios.js'></script>";
		echo "<script language='javascript' src='".$this->_path_scripts."/calendar/dhtmlgoodies_calendar.js?random='></script>";
	}
	
	function PoneLlamadasJavascriptAbajo() {
		if ($this->_existe_upload_imagenes) {
			echo "<script language='javascript'>
					 ActualizaListaImagenes();
				  </script>";
		}
		if ($this->_existe_upload_archivos) {
			echo "<script language='javascript'>
					 ActualizaListaArchivos();
				  </script>";
		}
	}
	
	function PoneImplementacionesDeEstilos() {
		echo "<link href='estiloformulario.css' rel='stylesheet' type='text/css'>";
		echo "<link href='".$this->_path_scripts."/calendar/dhtmlgoodies_calendar.css' rel='stylesheet' type='text/css'>";
	}
	
	function PoneAsteriscoValidador($indice) {
		$esrequerido = isset($this->_datos_campos[$indice]["validacion"]) ? $this->_datos_campos[$indice]["validacion"] : -1;
		$txt = $esrequerido != -1 ? "<span class='TextoFormularioRequerido'>*</span>" : "";
		return $txt;
	}
	
	function cambiaf_a_normal($fecha) {
		if ($fecha == "") {
			ereg("([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})", $fecha, $mifecha); 
			$lafecha=$mifecha[3]."-".$mifecha[2]."-".$mifecha[1];
		} else {
			$lafecha = "";
		}
		return $lafecha;
	} 
	
	function ObtenerSeteos() {
		if ($this->_seteos == "") {
			$this->_seteos = parse_ini_file("config.ini", TRUE);
		}
	}
	
}               
?>
