<?
// Ultima Edicin: 	13.12.2007
// Usuario:			Matias

class clsTablas {
	// seteos
	var $_argumentos = "";
	var $_path_imagenes = "imagenes/tablas";
	var $_path_scripts = "scripts";
	var $_columnas = 0;
	var $_unidad_medida = "%";
	var $_columna_check = false;
	var $_columna_numero = true;
	var $_columna_acciones = false;
	var $_parametros_btn_alta = "";
	var $_codigo_reporte = "";
	var $_nombre_tabla = "";
	var $_muestra_funciones = true;
	// datos
	var $_objidioma = "";
	var $_dato_columna = "";
	var $_dato_columna_acciones = "";
	var $_indice_acciones = -1;
	var $_cant_renglones = 60;
	var $_pagina = 1;
	var $_total_paginas = 1;
	var $_indices = "";
	var $_objetodatos = "";
	var $_filainicio = 0;
	var $_total_registros = 0;
	var $_dato_funciones_adicionales = "";
	var $_indice_funciones_adicionales = -1;
	var $_subtituloreporte = "";

	function clsTablas() {
		$this->PoneImplementacionesDeEstilos();
		$this->PoneFuncionesJavascript();
	}
	
	function Idioma($obj) {
		$this->_objidioma = $obj;
	}

	function MuestraFunciones($estado) {
		$this->_muestra_funciones = $estado;
	}

	function CodigoReporte($codigo) {
		$this->_codigo_reporte = $codigo;
	}

	function ColumnaNumero($estado) {
		$this->_columna_numero = $estado;
	}

	function ColumnaCheck($estado) {
		$this->_columna_check = $estado;
	}

	function AgregarFuncion($nombre, $titulo, $accion, $dato) {
		$this->_indice_funciones_adicionales++;
		$this->_dato_funciones_adicionales[$this->_indice_funciones_adicionales]["nombre"] = $nombre;
		$this->_dato_funciones_adicionales[$this->_indice_funciones_adicionales]["titulo"] = $titulo;
		$this->_dato_funciones_adicionales[$this->_indice_funciones_adicionales]["accion"] = $accion;
		$this->_dato_funciones_adicionales[$this->_indice_funciones_adicionales]["dato"] = $dato;
	}

	function AgregaAccion($accion, $etiqueta, $predefinida=true, $dato="[@id@]") {
		$this->_indice_acciones++;
		$this->_dato_columna_acciones[$this->_indice_acciones]["accion"] 	= $accion;
		$this->_dato_columna_acciones[$this->_indice_acciones]["etiqueta"] 	= $etiqueta;
		$this->_dato_columna_acciones[$this->_indice_acciones]["dato"] 		= $dato;
		$this->_dato_columna_acciones[$this->_indice_acciones]["predefinida"] = $predefinida;		
		if (!$this->_columna_acciones) {
			$this->_columna_acciones = true;
		}
	}

	function ObjetoDatos($obj) {
		$this->_objetodatos = $obj;
		$this->_total_registros = $obj->CantidadRegistros();
		$this->_cant_renglones = $obj->CantidadRenglones();
		$this->_pagina = $obj->PaginaActual();
		$this->_total_paginas = ceil($this->_total_registros/$this->_cant_renglones);
		$this->_filainicio = (($this->_pagina-1) * $obj->CantidadRenglones()) + 1;
		$this->_nombre_tabla = $obj->NombreTabla();
		$this->_codigo_reporte = $this->_nombre_tabla;		
	}
	
	function NombreTabla($nombre) {
		$this->_nombre_tabla = $nombre;
	}

	function AgregaColumna($key) {
		$this->_dato_columna[$key]->titulo = ucfirst($key);
		$this->_dato_columna[$key]->texto = "[@".$key."@]";
		$this->_dato_columna[$key]->ancho = -1;
		$this->_dato_columna[$key]->anchopixel = -1;
		$this->_dato_columna[$key]->alineacion = "c";
		$this->_dato_columna[$key]->contenidoresaltado = false;
		$this->_dato_columna[$key]->columnaestado = false;
		$this->_dato_columna[$key]->columnaimagen = false;
		$this->_dato_columna[$key]->columnafecha = false;
		$this->_dato_columna[$key]->enlace = "";
		$this->_dato_columna[$key]->imagenpath = "";
		$this->_dato_columna[$key]->formateodecimales = -1;
		$this->_dato_columna[$key]->formateollenaceros = -1;
		$this->_dato_columna[$key]->pre_thumbnails = "admin_thumbs_";
		$this->_indices[$this->_columnas] = $key;
		$this->_columnas++;
	}

	function SeteaPropiedad($prop,$valor) {
		// Obtengo el key de la ultima columna insertada
		$key = $this->_indices[$this->_columnas-1];
		$this->SeteaPropiedadNum($key,$prop,$valor);
	}

	function SeteaPropiedadNum($key,$prop,$valor) {
		$valor = str_replace("'","\'",$valor);
		eval("\$this->_dato_columna['".$key."']->".$prop." = '".$valor."';");
	}

	function ParametrosAlta($texto) {
		$this->_parametros_btn_alta = $texto;
	}

	function Mostrar() {
		$this->PoneFunciones();
		$this->PoneVistaYPaginado();
		echo "<table class='listTable' align='center' border='0' cellpadding='6' cellspacing='1'><tbody>";
		// Cabeceras
		echo "<tr class='listHeader'>";
		$this->PoneHeaderColumnaNumero();
		$this->PoneHeaderChecks();
		for ($col=0; $col<$this->_columnas; $col++) {
			$key = $this->ObtieneKey($col);
			echo "<td background='".$this->_path_imagenes."/fondo_header.jpg' ".$this->CalculaAnchoColumna($key)." ".$this->ExtraeAlineamiento($col).">".$this->TituloColumna($key)."</td>";
		}
		$this->PoneHeaderColumnaAcciones();
		echo "</tr>";
		// Datos
		$filaactual = 1;
		if ($this->_objetodatos->CantidadRegistros()>0){
			while (!$this->_objetodatos->Fin()) {
				echo "<tr class='TablaFila' onmouseover=\"javascript:this.style.backgroundColor='#F5FAFC'\" onmouseout=\"this.style.backgroundColor=''\">";
				$this->PoneColumnaNumero($_filaactual);
				$this->PoneColumnaChecks();
				for ($col=0; $col<$this->_columnas; $col++) {
					$key = $this->ObtieneKey($col);
	
					echo "<td class='".$this->ExtraeClaseStilo($col)."' ".$this->ExtraeAlineamiento($col).">".$this->ExtraeDatos($col)."</td>";
				}
				$this->PoneColumnaAcciones();
				echo "</tr>";
				$this->_objetodatos->MoverSiguiente();
				$_filaactual++;
			}
		$this->PoneFuncionesChecks();
		}else{
			echo "<tr><td  width=100% class='TablaCeldaResaltada' colspan=".$this->_columnas."><div align=\"center\"> No se Encontraron resultados</div></td></tr>";		
		}
		echo "</tbody>";
		$this->ArmaFormularioParaImpresion();
		echo "</table>";
		$this->PoneVistaYPaginado();
		echo "<br>";
	}

	function ExtraeDatos($col) {
		$key = $this->ObtieneKey($col);
		$contenido = $this->_dato_columna[$key]->texto;
		$decimales = $this->_dato_columna[$key]->formateodecimales;
		$enlace = $this->_dato_columna[$key]->enlace;
		$columnaestado = $this->_dato_columna[$key]->columnaestado;
		$columnaimagen = $this->_dato_columna[$key]->columnaimagen;
		$columnafecha = $this->_dato_columna[$key]->columnafecha;
		$llenaceros = $this->_dato_columna[$key]->formateollenaceros;
		$anchopixel = $this->_dato_columna[$key]->anchopixel;

		// Evalua traduccion de campos
		$contenido = $this->TraduceContenidosDeDatos($contenido,$decimales,$columnaestado,$key,$llenaceros);
		$contenido = $contenido != "" ? $contenido : "-";

		// Si es columna imagen
		if ($columnaimagen) {
			$path = $this->_dato_columna[$key]->imagenpath;
			$pre_thumbnails = $this->_dato_columna[$key]->pre_thumbnails;
			$arr_imagenes = explode("|",$contenido);
			$contenido = $path."/".$pre_thumbnails.$arr_imagenes[0];
	 		$contenido = file_exists($contenido) ? $contenido : "-";
			if ($contenido != "-") {
				$contenido = "<img border='1' style='border-color:#999999' src='".$contenido."'/>";
			}
		}
		
		// Si es fecha
		if ($columnafecha) {
			$contenido = $this->FormatoFecha($contenido);
		}
		
		// Evaluo si es enlace
		if ($enlace != "" && $contenido!="" && $contenido!="-") {
			$enlace = $this->TraduceContenidosDeDatos($enlace);
			$contenido = "<a class='datoLink' href='".$enlace."'>".$contenido."</a>";
		}
		
		// Si es autoajustar creo una tabla contenedora
		if ($anchopixel != -1) {
			$contenido = "<table align='center' border='0' cellpadding='0' cellspacing='0' width='".$anchopixel."px'><tr><td align='center'><span align='center' class='".$this->ExtraeClaseStilo($col)."'>".$contenido."</span></td></tr></table>";
		}
		
		return $contenido;
	}

	function TraduceContenidosDeDatos($texto, $decimales=-1, $columnaestado=false, $key="", $llenaceros=-1) {
		$datorenglon = get_object_vars($this->_objetodatos->datos);
		$salir = false;
		while (!$salir) {
			if (is_numeric(strpos($texto,"[@"))) {
				$inicio = strpos($texto,"[@")+2;
				$fin = strpos($texto,"@]");
				$largo = $fin-$inicio;

				// Busco los datos
				$variable = substr($texto, $inicio, $largo);
				$valor = $datorenglon[$variable];

				if ($columnaestado) {
					$valorestado = $valor;
					$valor = $valorestado ? "Si" : "No";
					$valor = " <a class='datoLink' href=\"javascript:AccionesPreestablecidasTabla('".$this->_nombre_tabla."','cambiaestado','".$key."|".$datorenglon["id"]."|".$valorestado."','&".$this->ArmaArgumentos()."')\">".$valor."</a>";
				}

				if ($decimales != -1) {
					$valor = number_format($valor, $decimales);
				}
				if ($llenaceros != -1) {
					$valor = sprintf("%0".$llenaceros."d",$valor);
				}
				// ---------------

				$texto = str_replace("[@".$variable."@]",$valor,$texto);

				$salir = false;
			} else {
				$salir = true;
			}
		}

		return $texto;
	}

	function ExtraeClaseStilo($col) {
		$estilo = "TablaCelda";
		$key = $this->ObtieneKey($col);
		if ($this->_dato_columna[$key]->contenidoresaltado) {
			$estilo = "TablaCeldaResaltada";
		}
		return $estilo;
	}

	function ObtieneKey($col) {
		$key = $this->_indices[$col];
		return $key;
	}

	function PoneColumnaChecks() {
		if ($this->_columna_check) {
			echo "<td width='1%'><input name='chk' type='checkbox' value='a'></input></td>";
		}
	}
	function PoneHeaderChecks() {
		if ($this->_columna_check) {
			echo "<td width='1%' background='".$this->_path_imagenes."/fondo_header.jpg'></td>";
		}
	}
	function PoneFuncionesChecks() {
		if ($this->_columna_check) {
			echo "<tr>";
			if ($this->_columna_numero) {
				echo "<td></td>";
			}
			echo "<td colspan=99>Marcar todos / Desmarcar todos / Eliminar Todos</td>";
			echo "<tr>";
		}
	}
	function PoneColumnaNumero($fila) {
		if ($this->_columna_numero) {
			echo "<td width='1%' bgcolor='#F1F3F5'><table align='center' border='0' cellpadding='0' cellspacing='0' width='35px'><tr><td class='TablaCelda' align='center'><span align='center'>";
			echo $this->_filainicio+$fila;
			echo "</span></td></tr></table></td>";
		}
	}
	function PoneHeaderColumnaNumero() {
		if ($this->_columna_numero) {
			echo "<td width='1%' background='".$this->_path_imagenes."/fondo_header.jpg'>".$this->_objidioma->Traducir("nro","tablas")."</td>";
		}
	}

	function PoneColumnaAcciones() {
		if ($this->_columna_acciones) {
			$cantacciones = count($this->_dato_columna_acciones);
			$ancho = (18 * $cantacciones) + 4;
			echo "<td width='1%'><table align='center' border='0' cellpadding='0' cellspacing='0' width='".$ancho."px'><tr><td><span align='center'>";
			for ($indiceaccion=0; $indiceaccion < $cantacciones; $indiceaccion++) {
				if ($this->_dato_columna_acciones[$indiceaccion]["predefinida"]) {
					$link = "javascript:AccionesPreestablecidasTabla('".$this->_nombre_tabla."','".$this->_dato_columna_acciones[$indiceaccion]["accion"]."','".$this->TraduceContenidosDeDatos($this->_dato_columna_acciones[$indiceaccion]["dato"])."','&".$this->ArmaArgumentos()."')";
				} else {
					$link = "javascript:".$this->_dato_columna_acciones[$indiceaccion]["accion"]."('".$this->TraduceContenidosDeDatos($this->_dato_columna_acciones[$indiceaccion]["dato"])."')";
				}
					echo " <a href=\"".$link."\"><img src='".$this->_path_imagenes."/".$this->_dato_columna_acciones[$indiceaccion]["accion"].".png' border='0' title=\"".$this->_objidioma->Traducir($this->_dato_columna_acciones[$indiceaccion]["etiqueta"],"tablas")."\"></a>";
			}
			echo "</span></td></tr></table></td>";
		}
	}

	function PoneHeaderColumnaAcciones() {
		if ($this->_columna_acciones) {
			echo "<td background='".$this->_path_imagenes."/fondo_header.jpg'>".$this->_objidioma->Traducir("acciones","tablas")."</td>";
		}
	}

	function PoneVistaYPaginado() {
		echo "<table border='0' align='center' cellpadding='2' cellspacing='2' width='95%' class='listPaginado'>
				<tbody><tr>
					<td align='left' class='textoPaginacion'>".$this->_objidioma->Traducir("visualizar","tablas").": <select class='textoPaginacionResaltado' name='newsletter_page' style='width: auto;'
					onchange=\"document.location='?' + this.value\">
				    <option label='20' value='".$this->ArmaArgumentos("",20)."' ".($this->_cant_renglones == 20 ? "selected='selected'" : "").">20</option>
					<option label='40' value='".$this->ArmaArgumentos("",40)."' ".($this->_cant_renglones == 40 ? "selected='selected'" : "").">40</option>
					<option label='60' value='".$this->ArmaArgumentos("",60)."' ".($this->_cant_renglones == 60 ? "selected='selected'" : "").">60</option>
					</select>
					</td><td align='center' width='50%' class='textoPaginacion'>
					".$this->PoneOpcionPaginas("pri")."
					".$this->PoneOpcionPaginas("ant")."
					".$this->_objidioma->Traducir("pagina","tablas")." <span class='textoPaginacionResaltado'>".$this->_pagina."</span> de <span class='textoPaginacionResaltado'>".$this->_total_paginas."</span>
					".$this->PoneOpcionPaginas("sig")."
					".$this->PoneOpcionPaginas("ult")."
					</td><td align='right' class='textoPaginacion'>".$this->_objidioma->Traducir("totalregistros","tablas").": <span class='textoPaginacionResaltado'>".$this->_total_registros."</span></td>
					</tr></tbody></table>";
	}

	function TotalColumnas() {
		$tot = $this->_columnas;
		if ($this->_columna_numero) {
			$tot++;
		}
		if ($this->_columna_check) {
			$tot++;
		}
		if ($this->_columna_acciones) {
			$tot++;
		}
		return $tot;
	}

	function PoneOpcionPaginas($opcion) {
		if ($opcion == "sig") {
			$paginaponer = $this->_pagina+1;
			if ($paginaponer <= $this->_total_paginas) {
				$txt = " <a href='?".$this->ArmaArgumentos($paginaponer)."'>></a> ";
			} else {
				$txt = " > ";
			}
		}
		if ($opcion == "ant") {
			$paginaponer = $this->_pagina-1;
			if ($paginaponer > 0) {
				$txt = " <a href='?".$this->ArmaArgumentos($paginaponer)."'><</a> ";
			} else {
				$txt = " < ";
			}
		}
		if ($opcion == "pri") {
			$paginaponer = 1;
			if ($this->_pagina != $paginaponer) {
				$txt = " <a href='?".$this->ArmaArgumentos($paginaponer)."'>|<</a> ";
			} else {
				$txt = " |< ";
			}
		}
		if ($opcion == "ult") {
			$paginaponer = $this->_total_paginas;
			if ($this->_pagina != $paginaponer) {
				$txt = " <a href='?".$this->ArmaArgumentos($paginaponer)."'>>|</a> ";
			} else {
				$txt = " >| ";
			}
		}

		return $txt;
	}

	function ArmaArgumentos($pagina = "", $tampagina = "") {
		if ($pagina != "") {
			$argumentos["p"] = "p=".$pagina;
		} else {
			$argumentos["p"] = "p=".$this->_pagina;
		}
		if ($tampagina != "") {
			$argumentos["t"] = "t=".$tampagina."&ri=".($this->_filainicio);
		} else {
			$argumentos["t"] = "t=".$this->_cant_renglones;
		}
		$argumentos["otros"] = $this->_argumentos;

		return implode("&",$argumentos);
	}

	function SeteaParametrosPaginacion($dato){
		$this->_argumentos = $dato;
	}
	function PoneFunciones() {
		if ($this->_muestra_funciones) {
			echo "<table border='0' align='center' cellpadding='2' cellspacing='2' width='95%'><tbody>";
			echo "<tr class='xxx'><td height='45px'>";
			echo "<input name='btnAlta' class='botonFuncionAlta' type='button' value='".$this->_objidioma->Traducir("nuevoregistro","tablas")."' onClick=\"javascript:AccionesPreestablecidasTabla('".$this->_nombre_tabla."','insertar','".$this->_parametros_btn_alta."','&".$this->ArmaArgumentos()."')\">";
			echo "<input name='btnImprimir' class='botonFuncion' type='button' value='".$this->_objidioma->Traducir("imprimir","tablas")."' onClick=\"javascript:AccionesPreestablecidasTabla('".$this->_nombre_tabla."','imprimir','')\">";
			if ($this->_indice_funciones_adicionales != -1) {
				for ($j=0; $j<count($this->_dato_funciones_adicionales); $j++) {
					$dato = $this->_dato_funciones_adicionales[$j];
					echo "<input name='btn".$dato["nombre"]."' class='botonFuncion' type='button' value='".$this->_objidioma->Traducir($dato["titulo"],"tablas")."' onClick=\"javascript:".$dato["accion"]."('".$dato["dato"]."')\">";
				}
			}
			
			echo "</td></tr>";
			echo "</tbody></table>";
		}
	}

	function PoneFuncionesJavascript() {
		echo "<script language='javascript' src='".$this->_path_scripts."/tablas.js'></script>";
	}

	function ObtieneHeaders() {
		$txt="";
		if ($this->_columnas != 0) {
			for ($j=0; $j<$this->_columnas; $j++) {
				$key = $this->ObtieneKey($j);
				$txt .= ($txt!="" ? "," : "").$this->_objidioma->Traducir(strtolower($this->_dato_columna[$key]->titulo),"general");
			}
		}
		return $txt;
	}

	function ObtieneCampos() {
		$txt="";
		
		if ($this->_columnas != 0) {
			for ($j=0; $j<$this->_columnas; $j++) {
				$key = $this->ObtieneKey($j);
				$txt .= ($txt!="" ? "," : "").$this->_dato_columna[$key]->texto;
			}
		}
		return $txt;
	}

	function ArmaFormularioParaImpresion() {
		echo "<form name='frmImpresion' id='frmImpresion' action='reportes.php' method='POST'>";
		echo "<input name='codigoreporte' type='hidden' value='".$this->_codigo_reporte."'>";
		echo "<input name='sqlsinpaginado' type='hidden' value='".$this->_objetodatos->ObtenerTxtSQL()."'>";
		echo "<input name='headers' type='hidden' value='".$this->ObtieneHeaders()."'>";
		echo "<input name='campos' type='hidden' value='".$this->ObtieneCampos()."'>";
		if($this->ObtieneSubtituloReporte() != ""){
			echo "<input name='subtitulo' type='hidden' value='".$this->ObtieneSubtituloReporte()."'>";
		}		
		echo "</form>";
	}
	
	//Convierte fecha de mysql a normal 
	function FormatoFecha($fecha) {
		ereg("([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})", $fecha, $mifecha); 
		$lafecha=$mifecha[3]."-".$mifecha[2]."-".$mifecha[1];
		return $lafecha; 
	}
	
	function CalculaAnchoColumna($key) {
		$txtmedida = "";
		if ($this->_dato_columna[$key]->anchopixel != -1) {
			$txtmedida = "1".$this->_unidad_medida;
		} elseif ($this->_dato_columna[$key]->ancho != -1) {
			$txtmedida = $this->_dato_columna[$key]->ancho.$this->_unidad_medida;
		}
		if ($txtmedida != "") {
			$txtmedida = " width='".$txtmedida."'";
		}
		return $txtmedida;
	}
	
	function ExtraeAlineamiento($col) {
		$texto = "";
		$key = $this->ObtieneKey($col);
		switch (strtolower($this->_dato_columna[$key]->alineacion)) {
			case "i": 
				$texto = "left";
				break;
			case "d": 
				$texto = "right";
				break;
			case "c": 
				$texto = "center";
				break;
		}
		$texto = " align='".$texto."'";
		
		return $texto;
	}
	
	function PoneImplementacionesDeEstilos() {
		echo "<link href='estilotabla.css' rel='stylesheet' type='text/css'>";
	}
	
	function TituloColumna($key) {
		$concepto = strtolower($this->_dato_columna[$key]->titulo);
		$titulo = $this->_objidioma->Traducir($concepto);
		return $titulo;
	}
	
	function Subtitulo($dato){
	$this->_subtituloreporte = $dato;
	}
	function ObtieneSubtituloReporte(){
		return $this->_subtituloreporte;
	}
	
}

?>
