<?
require_once("mysql.class.php");
require_once("utiles.php");

class clsDatos { 
    // Privadas
	var $_debugmode = false;
	var $_controleliminados = true;
	var $_campos = "*";
	var $_nombretabla = "";
	var $_join = "";
	var $_totalvisitas = 0;
	var $_totalregistros = 0;
	var $_cursor = 0;
	var $_ArrayDatos = array();
	var $_finarchivo = false;
	var $_formatohtml = true;
	var $_filtro = "";
	var $_orden = "";
	var $_grupo = "";
	var $_tampagina = 60;
	var $_nropagina = 1;
	
	// Publica
	var $datos = "";		// Objeto de lectura de datos
	
	function NombreTabla($txt=-1) {
		if ($txt!=-1) {
			$this->_nombretabla = $txt;
		}
		return $this->_nombretabla;
	}
	
	function AgregaLeftJoin($txt) {
		$this->AgregaJoin("LEFT",$txt);
	}
	
	function AgregaInnerJoin($txt) {
		$this->AgregaJoin("INNER",$txt);
	}
	
	function AgregaRightJoin($txt) {
		$this->AgregaJoin("RIGHT",$txt);
	}
	
	function AgregaJoin($tipo,$txt) {
		$this->_join .= " ".strtoupper($tipo)." JOIN ".$txt;
	}
	
	function Campos($txt) {
		$this->_campos = $txt;
	}	
	
	function ControlEliminados($estado) {
		$this->_controleliminados = $estado;
	}
		
	function ArmaFiltro() {
		$txtfiltro = $this->_filtro;
		if ($this->_controleliminados) {
			$txtfiltro .= (trim($txtfiltro)=="") ? " WHERE " : " AND ";
			$txtfiltro .= $this->_nombretabla.".eliminado = 0 ";
		}
		return $txtfiltro;
	}
	
	function DebugMode($estado) {
		$this->_debugmode = $estado;	
	}
	
	function Filtro($texto) {
		if (trim($texto) != "") {
			$this->_filtro = "WHERE ".$texto;
		}
	}
	
	function Orden($texto) {
		if (trim($texto) != "") {
			$this->_orden = "ORDER BY ".$texto;
		}
	}
	
	function Grupo($texto) {
		if (trim($texto) != "") {
			$this->_grupo = "GROUP BY ".$texto;
		}
	}

	function EjecutarSQL($instruccion) {
		$sql = new clsMySQL();
		$this->_txtsql = $instruccion;
		$sql->Query($this->_txtsql);
		$this->PoneDebug();
		$this->ObtieneConsulta($sql);
		$sql->Close();
	}

	function Pagina($dato) {
		$this->_nropagina = $dato;
	}
	
	function CalculaPaginaDesdeRegistroInicial($dato) {
		$this->_nropagina = ceil($dato / $this->_tampagina);
	}
	
	function TamPagina($dato) {
		$this->_tampagina = $dato;
	}
	
	function ObtenerDatos($paginado = true) {
		$sql = new clsMySQL();
		
		// Genero el nro total de registros
		$this->_finarchivo = false;
		$this->_txtsql = "SELECT COUNT(*) AS cantidad FROM ".$this->_nombretabla.$this->_join." ".$this->ArmaFiltro()." ".$this->_grupo;
		$sql->Query($this->_txtsql);
		$this->PoneDebug();
		$this->_txtsql = "";
		if ($sql->LeerObjeto()) {
			$this->_totalregistros = $sql->ObjetoFila->cantidad;
		} else {
			$this->_totalregistros = 0;
			$this->_finarchivo = true;
		}
		if (!$this->_finarchivo && $this->_totalregistros!=0) {
			if ($paginado) {
				$strlimit = " LIMIT ".($this->_tampagina * ($this->_nropagina-1)).",".$this->_tampagina;
			} else {
				$this->_tampagina = $this->_totalregistros;
				$strlimit = " LIMIT 0,".$this->_tampagina;
			}
			$this->_txtsql = "SELECT ".$this->_campos." FROM ".$this->_nombretabla.$this->_join." ".$this->ArmaFiltro()." ".$this->_grupo." ".$this->_orden." ".$strlimit;
			$this->PoneDebug();
			$sql->Query($this->_txtsql);
			$this->ObtieneConsulta($sql);	
		} else {
			$this->_finarchivo = true;
		}
	}
	
	function ObtieneConsulta($obj) {
		$this->_cursor = 0;
		$this->_ArrayDatos = "";
		if ($obj->TotalRegistros() > 0) {
			while ($obj->LeerObjeto()) { 
				$this->_ArrayDatos[$this->_cursor] = $obj->ObjetoFila;
				$this->_cursor++;
			}
			$this->_cursor = 0;
			$this->Asignar();
			$this->_finarchivo = false;
		} else {
			$this->_finarchivo = true;
		}
		$obj->Close();
	}
	
	function Asignar() {	
		/*if ($this->_formatohtml) {
			$vars = get_object_vars($this->_ArrayDatos[$this->_cursor]);
			$valores = "";
			foreach ($vars as $variable=>$val) {
				if(!$this->ComprobarHTML($val)){ 				
					$val = formatoHTML($val);					
				}
				$val = str_replace("\"","'",$val);
				eval("\$this->_ArrayDatos[\$this->_cursor]->".$variable." = \"$val\";");
			}
		}*/
		$this->datos = $this->_ArrayDatos[$this->_cursor];
	}
	
	function ObtenerTxtSQL() {
		$texto = "SELECT ".$this->_campos." FROM ".$this->_nombretabla.$this->_join." ".$this->ArmaFiltro()." ".$this->_grupo." ".$this->_orden;
		return $texto;
	}
	
	function SeteaDatoColumna($nombre, $valor) {
		eval("\$this->_ArrayDatos[\$this->_cursor]->".$nombre." = '".$valor."';");
	}
	
	function ObtenerDatosSQL($instruccion) {
		$sql = new clsMySQL();
		$this->_txtsql = $instruccion;
		$this->PoneDebug();
		$sql->Query($this->_txtsql);
		$this->ObtieneConsulta($sql);
	}
	
	function Insertar() {
		$sql = new clsMySQL(); 
		$campos = "";
		$valores = "";
		$vars = get_object_vars($this->datos);
		foreach ($vars as $name=>$val) { 
			if (strtoupper($name) != "ID") {
				if ($campos != "")  { $campos .= ", "; }
				if ($valores != "") { $valores .= ", "; }
				$val = str_replace("\'","'",$val);
				$val = str_replace("\\\\","/",$val);			
				$val = str_replace("'","\'",$val);
		    	$campos .= "$name"; 
				$valores .= "'$val'"; 
			}
		} 
		$this->_txtsql = "INSERT INTO ".$this->_nombretabla." (".$campos.") VALUES (".$valores.")";
		$this->PoneDebug();
		if ($sql->Query($this->_txtsql)) { 
			$this->datos->id = $sql->IDUltimoInsert();		    
			return $this->datos->id;
		} else {
		    return -999;
		}
		$sql->Close();
	}
	
	function Update($id=-1) {
		$sql = new clsMySQL(); 
		$id = $id!=-1 ? $id : $this->datos->id;
		$condiciones = " WHERE id=".$id;
		$campos = "";
		$vars = get_object_vars($this->datos);
		foreach ($vars as $name=>$val) { 
			$campos .= $campos!="" ? ", " : "";
			$val = str_replace("\'","'",$val);
			$val = str_replace("\\\\","/",$val);			
			$val = str_replace("'","\'",$val);			
			if ($name!="id") {
		    	$campos .= "$name = '$val'"; 
			}
		}
		$this->_txtsql = "UPDATE ".$this->_nombretabla." SET ".$campos." ".$condiciones;
		$this->PoneDebug();
		if ($sql->Query($this->_txtsql)) {
		   return true;
		} else {
		   return false;
		}
	}
	
	function Borrar($id=-1) {
		$sql = new clsMySQL(); 
		$id = $id!=-1 ? $id : $this->datos->id;
		$condiciones = " WHERE id=".$id;
		$this->_txtsql = "UPDATE ".$this->_nombretabla." SET eliminado = 1 ".$condiciones;
		$this->PoneDebug();
		if ($sql->Query($this->_txtsql)) {
		   return true;
		} else {
		   return false;
		}
	}
	
	function MoverPrimero()	{
		$this->_cursor = 0;
		if ($this->_cursor == 0 && $this->_tampagina == 0) {	
			$this->_finarchivo = true; 
		} else { 
			$this->_finarchivo = false; 
		}
		$this->Asignar();
	}
	
	function MoverUltimo() {
		$maximo = count($this->_ArrayDatos)-1;
		$this->_cursor = $maximo;
		$this->Asignar();
	}
	
	function MoverSiguiente() {
		$maximo = count($this->_ArrayDatos)-1;
		$this->_cursor++;
		if ($this->_cursor <= $maximo) {
			$this->Asignar();
			return true;
		} else {
			$this->_finarchivo = true;
			return false;	
		}
	}

	function MoverAnterior() {
		$this->_cursor--;
		if ($this->_cursor >= 0) {
			$this->Asignar();
			return true;
		} else {
			return false;	
		}
	}
	
	function Fin() {
		return $this->_finarchivo;
	}
	
	function CantidadRegistros() {
		return $this->_totalregistros;
	}
	
	function CantidadRenglones() {
		return $this->_tampagina;
	}
	
	function PaginaActual() {
		return $this->_nropagina;
	}
	
	function PoneDebug() {	
		if ($this->_debugmode) {
			echo "->".$this->_txtsql."<br>";
		}
	}
	
	function ComprobarHTML($valor){
		$encontro = false;
		$reglas = "&aacute;&Aacute;&atilde;&Atilde;&acirc;&Acirc;&agrave;&Agrave;&eacute;&Eacute;&ecirc;&Ecirc;&iacute;&Iacute;&oacute;&Oacute;&otilde;&Otilde;&ocirc;&Ocirc;&uacute;&Uacute;&uuml;&Uuml;&ccedil;&Ccedil;&nbsp;&amp;&gt;&lt;&circ;&tilde;&uml;&cute;&cedil;&quot;&ldquo;&rdquo;&lsquo;&rsquo;&lsaquo;&rsaquo;&laquo;&raquo;&ordm;&ordf;&ndash;&mdash;&shy;&macr;&hellip;&brvbar;&bull;&para;&sect;&spades;&clubs;&hearts;&diams;&copy;&reg&trade;&pound;&cent;&euro;&yen;&curren;&sup1;&sup2;&sup3;&frac12;&frac14;&frac34;&gt;&lt;&plusmn;&minus;&times;&divide;&lowast;&frasl;&permil;&int;&sum;&prod;&radic;&infin;&asymp;&cong;&prop;&equiv;&ne;&le;&ge;&there4;&sdot;&middot;&part;&image;&real;&prime;&Prime;&deg;&ang;&perp;&nabla;&oplus;&otimes;&alefsym;&oslash;&Oslash;&isin;&notin;&cap&cup;&sub;&sup;&sube;&supe;&exist;&forall;&empty;&not;&and;&or;&crarr;&larr&rarr;&uarr;&darr;&harr;&lArr;&hrrr;&uArr;&dArr;&hArr;&lceil&rceil;&lfloor;&rfloor;&loz;&ntilde;&Ntilde;&iexcl;&iquest;&auml;&Auml;&aring;&Aring;&euml;&Euml;&grave;&Egrave;&iuml;&Iuml;&igrave;&Igrave;&icirc;&Icirc;&ouml;&Ouml;&ograve;&Ograve;&ugrave;&Ugrave;&ucirc;&Ucirc;&yacute;&Yacute;&yuml;&Yuml;&aelig;&AElig;&oelig;&OElig;&dagger;&Dagger;&scaron;&Scaron;&thorn;&THORN;&eth;&ETH;&sect;&fnof;&szlig;&micro;&alpha;&Alpha;&beta;&Beta;&gamma;&Gamma;&delta;&Delta;&epsilon;&Epsilon;&zeta;&Zeta;&eta;&Eta;&theta;&Theta;&iota;&Iota;&kappa;&Kappa;&lambda;&Lambda;&mu;&Mu;&nu&Nu;&xi;&Xi;&omicron;&Omicron;&pi;&Pi;&rho;&Rho;&sigma;&Sigma;&sigmaf;&tau;&Tau;&upsilon;&Upsilon;&phi;&Phi;&chi;&Chi;&psi;&Psi;&omega;&Omega;&thetasym;&upsih;&piv;&<br>&<p>";
		$etiquetas = explode("&",$reglas);
		for ($i=1;$i<count($etiquetas);$i++){
			$encontro = strpos($valor, $etiquetas[$i]);			
			if ($encontro !== false) {				
				$encontro = true;
				break;
			}			
		}		
		return $encontro;		
	}
	
	function CantidadRegistrosTabla($tabla,$filtro="") {
		$sql = new clsMySQL(); 
		$filtro = $filtro != "" ? " WHERE ".$filtro : "";
		$sql->Query("SELECT COUNT(id) AS cantidad FROM ".$tabla." ".$filtro);
		if ($sql->LeerObjeto()) {
			$total = $sql->ObjetoFila->cantidad;
		} else {
			$total = 0;
		}
		return $total;
	}
	
	function ObtenerRegistro($id=-1) {
		$sqlaux = new clsMySQL(); 
		$datoid = $id!=-1 ? $id : $this->datos->id;
		$sqlaux->Query("SELECT * FROM ".$this->_nombretabla." WHERE id=".$datoid);
		if ($sqlaux->LeerArreglo()) { 
			$dato = $sqlaux->ArregloFila;
		} else {
			$dato = "";
		}
		return $dato;
	}
	
	function ObtenerMatrix() {
		$txt_matrix = "";
		for ($i=0; $i<count($this->_ArrayDatos); $i++) {
			$vars = get_object_vars($this->_ArrayDatos[$i]);
			$txt_matrix .= $txt_matrix != "" ? "|#|" : "";
			$txt_matrix .= implode("|;|",$vars);
		}
		return $txt_matrix;
	}
	
	/*function BorrarConCriterio($condiciones)
	{
		$sql = new clsMySQL(); 
		if ($sql -> Query ("DELETE FROM ".$this->nombretabla." ".$condiciones)) {
		   return true;
		} else {
		   return false;
		}
		$sql -> Close();
	}
	
	
	
	function ProximoCodigo($campo = "codigo")
	{
		$sqlaux = new clsMySQL(); 
		$sqlaux->Query("SELECT MAX(".$campo.") AS maximo FROM ".$this->nombretabla);
		if ($sqlaux->LeerObjeto()) {
			$maximo=$sqlaux->ObjetoFila->maximo;
		} else {
			$maximo=0;
		}

		$sqlaux->Close();
		
		return $maximo+1;
	}
	 */
} 
?>